//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID7bfdcda2_71b4_4d98_a970_9feb9f11925c
{
    public class Class___Resize__obsolete_ : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            SizeX = 2,
            SizeY = 3
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var SizeX = inputs[(int)InputId.SizeX].Eval(context).Value;
            var SizeY = inputs[(int)InputId.SizeY].Eval(context).Value;
            var Size = new Vector2(SizeX, SizeY);
            //<<< _params

            using (new PropertyStasher<OperatorPartContext>(context, "Viewport")) 
            {
                //context.Viewport = new ViewportF(0, 0, SizeX, SizeY);
    
                return PrepareAndEvalOnChange(context, () =>
                {
                    ClearRenderTarget(context, new Color4(0, 0, 0, 0));
    
                    //>>> _setup
                    using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                    {
                        _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                        _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                        _effect.GetVariableByName("Size").AsVector().Set(new Vector2(SizeX, SizeY));
                        //<<< _setup
    
                        Render(context);

                    //>>> _cleanup
                    }
                    //<<< _cleanup
                });
            }
        }
    }
}

